VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "2 Point Source Memory List Using NI-VISA and SCPI Commands to a 6430"
   ClientHeight    =   8745
   ClientLeft      =   1530
   ClientTop       =   1845
   ClientWidth     =   8535
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   8745
   ScaleWidth      =   8535
   Begin VB.Frame Frame2 
      Caption         =   "Source Memory Location #1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1365
      Left            =   450
      TabIndex        =   18
      Top             =   6000
      Width           =   3390
      Begin VB.TextBox txtCurrentSML2 
         Height          =   285
         Left            =   2400
         TabIndex        =   20
         Text            =   "0.0015"
         Top             =   300
         Width           =   765
      End
      Begin VB.TextBox txtComplianceSML2 
         Height          =   285
         Left            =   2400
         TabIndex        =   19
         Text            =   "20"
         Top             =   750
         Width           =   765
      End
      Begin VB.Label Label9 
         Caption         =   "Current Value to Source: "
         Height          =   240
         Left            =   225
         TabIndex        =   22
         Top             =   300
         Width           =   1890
      End
      Begin VB.Label Label8 
         Caption         =   "Voltage Compliance (Limit) : "
         Height          =   240
         Left            =   225
         TabIndex        =   21
         Top             =   750
         Width           =   1965
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Source Memory Location #1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1365
      Left            =   450
      TabIndex        =   12
      Top             =   4350
      Width           =   3390
      Begin VB.TextBox txtComplianceSML1 
         Height          =   285
         Left            =   2400
         TabIndex        =   17
         Text            =   "15"
         Top             =   750
         Width           =   765
      End
      Begin VB.TextBox txtCurrentSML1 
         Height          =   285
         Left            =   2400
         TabIndex        =   15
         Text            =   "0.001"
         Top             =   300
         Width           =   765
      End
      Begin VB.Label Label5 
         Caption         =   "Voltage Compliance (Limit) : "
         Height          =   240
         Left            =   225
         TabIndex        =   16
         Top             =   750
         Width           =   1965
      End
      Begin VB.Label Label4 
         Caption         =   "Current Value to Source: "
         Height          =   240
         Left            =   225
         TabIndex        =   14
         Top             =   300
         Width           =   1890
      End
   End
   Begin VB.ListBox lstVolts 
      Height          =   2595
      Left            =   4800
      TabIndex        =   9
      Top             =   4800
      Width           =   1935
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Execute List"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   8
      Top             =   3480
      Width           =   2175
   End
   Begin VB.CommandButton cmdSession 
      Caption         =   "Open VISA Session"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   6
      Top             =   1320
      Width           =   2175
   End
   Begin VB.CommandButton cmdIDN 
      Caption         =   "Send *IDN?"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   5
      Top             =   1920
      Width           =   2175
   End
   Begin VB.ComboBox Combo1 
      Height          =   315
      ItemData        =   "frmMain.frx":0000
      Left            =   3000
      List            =   "frmMain.frx":0002
      TabIndex        =   4
      Top             =   720
      Width           =   2055
   End
   Begin VB.CommandButton cmdOpen 
      Caption         =   "Find VISA Resources"
      Height          =   375
      Left            =   480
      TabIndex        =   3
      Top             =   720
      Width           =   2175
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close VISA Session"
      Height          =   375
      Left            =   5775
      TabIndex        =   2
      Top             =   7875
      Width           =   2175
   End
   Begin VB.CommandButton cmdReset 
      Caption         =   "Reset Instrument (*RST)"
      Enabled         =   0   'False
      Height          =   375
      Left            =   450
      TabIndex        =   1
      Top             =   2475
      Width           =   2175
   End
   Begin VB.Label Label3 
      Caption         =   $"frmMain.frx":0004
      Height          =   1590
      Left            =   5250
      TabIndex        =   13
      Top             =   300
      Width           =   2865
   End
   Begin VB.Label Label2 
      BackColor       =   &H8000000E&
      Caption         =   "Voltage Data"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   4875
      TabIndex        =   11
      Top             =   4350
      Width           =   1335
   End
   Begin VB.Label lblSweep 
      BackColor       =   &H8000000E&
      Caption         =   "Execution Status....."
      Height          =   375
      Left            =   3075
      TabIndex        =   10
      Top             =   3480
      Width           =   4215
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   600
      TabIndex        =   7
      Top             =   120
      Width           =   1845
   End
   Begin VB.Label lblIDN 
      BackColor       =   &H8000000E&
      Height          =   750
      Left            =   2880
      TabIndex        =   0
      Top             =   2100
      Width           =   4695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' In Visual Basic, the VISA library can be referenced by choosing Project >> References
' and selecting Visa Library from the list (you may first need to browse for visa32.dll).
' This allows the VISA functions and VISA data types to be used in a program
' without inclusion of a module file (*.bas).
'
' use object browser (F2) to see the VISA library......

' this example was tested with a Model 6430 SourceMeter with firmware level C17
' VB6 Professional, NI-VISA 2.6
'
Dim defaultRM As ViSession
Dim status As ViStatus
Dim response As String * VI_FIND_BUFLEN
Dim descriptor As String * VI_FIND_BUFLEN
Dim nlist As ViFindList
Dim sesn As ViSession
Const MAX_CNT = 5000
Dim retCount As ViUInt32
Dim buffer As String * MAX_CNT




Private Sub cmdClose_Click()
If sesn <> 0 Then
    ' put instrument back to local
    status = viGpibControlREN(sesn, VI_GPIB_REN_DEASSERT_GTL)
    status = viClose(sesn)
End If
End
End Sub


Private Sub cmdIDN_Click()
' ask for identification info
status = viWrite(sesn, "*IDN?", 5, retCount)
status = viRead(sesn, buffer, MAX_CNT, retCount)
lblIDN.Caption = buffer
End Sub

Private Sub cmdOpen_Click()
Dim x As Integer
' First we must call viOpenDefaultRM to get the manager handle
' We will store this handle in defaultRM.  The function viStatusDesc
' returns a text description of the status code returned by viOpenDefaultRM

status = viOpenDefaultRM(defaultRM)
'status = viStatusDesc(defaultRM, status, response)
status = viFindRsrc(defaultRM, "?*INSTR", nlist, retCount, descriptor)

If retCount <> 0 Then
Combo1.AddItem descriptor  ' populate first resource into our combo box
x = 1
While (x < retCount)
    status = viFindNext(nlist, descriptor)
    status = viStatusDesc(defaultRM, status, response)
    'Debug.Print "viFindNext", Hex(status), response
    'Debug.Print "The next resource is", descriptor
    Combo1.AddItem descriptor
    x = x + 1
Wend
Else
MsgBox "Could not detect any VISA resources on this system.", vbCritical
End If

'set combo equal to first detected resource
If retCount <> 0 Then
Combo1.ListIndex = 0
cmdSession.Enabled = True
End If


End Sub

Private Sub cmdReset_Click()
Dim cmd As String
cmd = "*RST"
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = "*CLS"
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":OUTP:SMODE NORM"
status = viWrite(sesn, cmd, Len(cmd), retCount)
buffer = ""  'reset buffer
cmdStart.Enabled = True  ' enable our start button
End Sub

Private Sub cmdSession_Click()
' Open communication with Resource identified in combo box (gets a session handle)
status = viOpen(defaultRM, Combo1.Text, VI_NULL, VI_NULL, sesn)
' Ines is GPIB2
' CEC or NI will be GPIB0
 If status = 0 Then

'set the timeout for message-based communication
status = viSetAttribute(sesn, VI_ATTR_TMO_VALUE, 30000)
' enable other command buttons
cmdIDN.Enabled = True
cmdReset.Enabled = True
End If
End Sub

Private Sub cmdStart_Click()
cmdStart.Enabled = False
' enable VISA Events
status = viEnableEvent(sesn, VI_EVENT_SERVICE_REQ, VI_QUEUE, VI_NULL)

' send SCPI commands to set up an IV sweep
lblSweep.Caption = "Programming Instrument for the Source Memory List..."
DoEvents
Dim cmd As String
cmd = "*SRE 1"              'Enable service request generation"
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":STAT:MEAS:ENAB 512"  'SRQ on buffer full
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":TRAC:FEED:CONT NEVER"   'turn off buffer
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":TRAC:CLE"   'clear any readings from trace buffer
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":Form:ELEM VOLT"  ' send volts back in our readings
status = viWrite(sesn, cmd, Len(cmd), retCount)

'Begin configuration on memory location 1
cmd = ":SOUR:FUNC CURR"       'Configure instrument to source current
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SOUR:CURR:RANG:AUTO ON"       'Select Current Range
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SOUR:CURR " & txtCurrentSML1.Text    'Set current source amount
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SENS:FUNC 'VOLT'"           'Measure voltage"
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SENS:VOLT:NPLC 0.01"     'Set integration rate on voltage measurement = 0.01 PLC"
status = viWrite(sesn, cmd, Len(cmd), retCount)

' Set voltage compliance
' IMPORTANT! must be greater than expected measured values of voltage,
' see pg. 3-19 to 3-20 in User's manual)"
cmd = ":SENS:VOLT:PROT " & txtComplianceSML1.Text
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SENS:VOLT:RANG:AUTO ON"   'Use Auto Ranging for Voltage
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SOUR:DEL 0.2"         'Set source delay = 200 msec
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SOUR:MEM:SAVE 1"
status = viWrite(sesn, cmd, Len(cmd), retCount)

'Begin configuration on memory location 2
cmd = ":SOUR:FUNC CURR"       'Configure instrument to source current
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":SOUR:CURR:RANG:AUTO ON"       'Select Current Range
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":SOUR:CURR " & txtCurrentSML2.Text    'Set current source value
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":SENS:FUNC 'VOLT'"           'Measure voltage
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":SENS:VOLT:NPLC 0.01"     'Set integration rate on voltage measurement = 0.01 PLC"
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":SENS:VOLT:PROT " & txtComplianceSML2.Text
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":SENS:VOLT:RANG:AUTO ON"   'voltage measurement range
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":SOUR:DEL 0.2"         'Set source delay = 200 msec
status = viWrite(sesn, cmd, Len(cmd), retCount)
cmd = ":SOUR:MEM:SAVE 2"
status = viWrite(sesn, cmd, Len(cmd), retCount)


''''''''
        
cmd = ":ARM:SOUR IMM"         'Set arm source = immediate (default)"
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":ARM:COUN 10"     'Set arm count.  This is the number of times
                        'you would like to make use of the SourceMemory locations
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":TRIG:SOUR IMM"        'Set trigger layer source = immediate (default)
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":TRIG:COUN 2"  'trigger countMUST equal number of points in source memory list
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":TRAC:POIN 20"         'Configure buffer size = trigger count * arm count
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SOUR:FUNC MEM"  'Source function mode = source memory
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SOUR:MEM:POIN 2"         '2 points in source memory sweep (MUST equal trigger count)
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":SOUR:MEM:STAR 1"         'Start at source memory location 1
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":TRAC:FEED SENS"  ' what should feed the buffer
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":TRAC:FEED:CONT NEXT"  ' how to feed the buffer
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":OUTP ON"  ' turn the output on
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":INIT"   ' start the measurements
status = viWrite(sesn, cmd, Len(cmd), retCount)

' this example is making use of SRQ for instrument to tell us when it is done.
Dim timeOut As ViUInt32
Dim evtHandle As ViEvent
Dim evtType As ViEventType
Dim STBresult As ViUInt16

timeOut = 30000
status = viWaitOnEvent(sesn, VI_EVENT_SERVICE_REQ, timeOut, evtType, evtHandle)

status = viReadSTB(sesn, STBresult)

        lblSweep.Caption = "Sweep is complete"
        

Dim readings() As String
Dim i As Integer
cmd = ":OUTP OFF"  ' turn the output off
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = "*SRE 0"  'Reset SRQ bit.
status = viWrite(sesn, cmd, Len(cmd), retCount)

cmd = ":TRAC:DATA?"  ' get data from the trace buffer
status = viWrite(sesn, cmd, Len(cmd), retCount)

' now read back the data
status = viRead(sesn, buffer, MAX_CNT, retCount)

' populate listbox with data in buffer
readings = Split(buffer, ",")   ' split the string at the commas
lstVolts.Clear
For i = 0 To 19  ' number of TRAC:POIN - 1
lstVolts.AddItem Format(readings(i), "#0.###0")
Next i

cmdStart.Enabled = True

End Sub


